const express = require('express');
const router = express.Router();
const mysqlConnection = require('../database');
const bcrypt = require('bcrypt');
const crypto = require("crypto");

const {
    signAccessToken,
    verifyAccessToken

} = require('../../services/jwt.service');

SALT_WORK_FACTOR = 10;
//var authService = require('../../services/auth.service');
//authService.passport.authenticate(authService.passportConfig.strategiesNames.check, {session : false}
//GET ALL USERS
router.post('/Users/get', async (req, res) => {
    const token = req.body['token'];
    var userId = await verifyAccessToken(token);
    let query = "SELECT * FROM usuario where idusuario = '" + userId + "';";
    try {
        let result = await mysqlConnection.promise().query(query);
        if (result[0].length > 0) {
            query = 'SELECT * FROM usuario';
            try {
                let result = await mysqlConnection.promise().query(query);
                res.json({ user: result[0] });
            }
            catch (err) {
                res.json({ "ERROR: ": err });
                return;
            }
        }
        else {
            res.json({ "ERROR: ": "TOKEN INVALIDO" });
        }
    }
    catch (err) {
        res.json({ "ERROR: ": err });
    }
});

//CREATE NEW USER
router.post('/Users/create', async (req, res) => {
    const token = req.body['token'];
    var userId = await verifyAccessToken(token);
    let query = "SELECT * FROM usuario where idusuario = '" + userId + "';";
    try {
        let result = await mysqlConnection.promise().query(query);
        if (result[0].length > 0) {
            const salt = await bcrypt.genSalt(SALT_WORK_FACTOR);
            const { clave, nombre, correo, grupo, usuario } = req.body;
            var clave2 = await bcrypt.hash(clave, salt);
            const query = "INSERT INTO usuario (clave, Nombre, Correo, grupo, usuario) values ('" + clave2 + "','" + nombre + "','" + correo + "'," + grupo + ",'" + usuario + "');";
            try {
                let result = await mysqlConnection.promise().query(query);
                if (result[0].affectedRows == 1) {
                    res.json({ "resultado: ": "insertado" });
                }
                else {
                    res.json({ "ERROR: ": result[0] });
                }
            }
            catch (err) {
                res.json({ "ERROR: ": err });
            }
        }
        else {
            res.json({ "ERROR: ": "TOKEN INVALIDO" });
        }
    }
    catch (err) {
        res.json({ "ERROR: ": err });
    }
});

//UPDATE USER
router.post('/Users/update', async (req, res) => {
    const token = req.body['token'];
    var userId = await verifyAccessToken(token);
    let query = "SELECT * FROM usuario where idusuario = '" + userId + "';";
    try {
        let result = await mysqlConnection.promise().query(query);
        if (result[0].length > 0) {
            const { clave, nombre, correo, grupo, usuario, idusuario } = req.body;
            query = "UPDATE usuario SET clave = '"+clave+"', nombre = '"+nombre+"', correo = '"+correo+"', grupo = '"+grupo+"', usuario = '"+usuario+"' WHERE idusuario = '"+idusuario+"'";
            try{
                let result = await mysqlConnection.promise().query(query);
                if (result[0].affectedRows == 1) {
                    res.json({ "resultado: ": "actualizado" });
                }
                else {
                    res.json({ "ERROR: ": result[0] });
                }
            }
            catch(err){
                res.json({ "ERROR: ": err});
            }
        } else {
            res.json({ "ERROR: ": "TOKEN INVALIDO" });
        }
    }
    catch (err) {
        res.json({ "ERROR: ": err });
    }
});

//DELETE USER
router.post('/Users/delete', async (req, res) => {
    const token = req.body['token'];
    var userId = await verifyAccessToken(token);
    let query = "SELECT * FROM usuario where idusuario = '" + userId + "';";
    try {
        let result = await mysqlConnection.promise().query(query);
        if (result[0].length > 0) {
            const { idusuario } = req.body;
            query = " DELETE FROM usuario WHERE idusuario = '"+idusuario+"'";
            try {
                let result = await mysqlConnection.promise().query(query);
                if (result[0].affectedRows == 1) {
                    res.json({ "resultado: ": "borrado" });
                }
                else {
                    res.json({ "ERROR: ": result[0] });
                }
            }
            catch(err){
                res.json({ "ERROR: ": result[0] });
            }
        } else {
            res.json({ "ERROR: ": "TOKEN INVALIDO" });
        }
    }
    catch (err) {
        res.json({ "ERROR: ": err });
    }
});

//LOGIN
router.post('/login', async (req, res) => {
    const { usuario, pass } = req.body;
    const query = "SELECT * FROM usuario WHERE usuario = '" + usuario + "';";
    try {
        let result = await mysqlConnection.promise().query(query);
        if (result[0].length > 0) {
            const match = await bcrypt.compare(pass, result[0][0].clave);
            //console.log(result[0][0].clave);
            if (match) {
                const accessToken = await signAccessToken(result[0][0].idusuario)
                //const refreshToken = await signRefreshToken(result[0][0].idusuario)
                const query = "SELECT * FROM grupo WHERE idgrupo = '" + result[0][0].grupo + "';";
                try {
                    let result2 = await mysqlConnection.promise().query(query);
                    res.json({ "user": result[0][0], accessToken, "group": result2[0][0] });
                }
                catch (err) {
                    console.error("ERROR: ", err);
                }
            }
            else {
                res.json({ "err": "contraseña incorrecta" });
            }

        }
        else {
            res.json({ "err": "usuario no encontrado" });
        }

    }
    catch (err) {
        console.error("ERROR: ", err);
        return;
    }
});


module.exports = router;

