// importa configuraciones
const JWT_SECRET_KEY = require('../config/jwt.conf');
const bcryptConf = require('../config/bcrypt.conf');
const passportConf = require('../config/passport.conf');
var RefreshToken = require('../model/RefreshToken.js');




const crypto = require("crypto");

// importa passport y modulos passport-jwt
const jwt = require('jsonwebtoken');
const passport = require('passport');
const passportJWT = require('passport-jwt');
const bcrypt = require('bcrypt');
//var RefreshToken = require('../model/RefreshToken.js');


// ExtractJwt se emplea para extraer el token con facilidad
let ExtractJwt = passportJWT.ExtractJwt;

let jwtOptions = {
    jwtFromRequest: ExtractJwt.fromAuthHeaderAsBearerToken(),
    secretOrKey: JWT_SECRET_KEY,
};

// Strategy for the authentication
let JwtStrategy = passportJWT.Strategy;
let userLevelStrategy = new JwtStrategy(jwtOptions, function (jwt_payload, next) {

    if(jwt_payload){
        console.log('PAYLOAD RECIBIDO: ', jwt_payload);
        // verifica el token del usuario
        User.select(user, (err, data) => {
            // app erro
            if (err) {
              res.status(500).json({
                error: 500,
                message: err,
              });
              next(null, false);
            }
        
            if (data) {
                next(null, jwt_payload.user);
            }
            
        });
    }
    console.error('no token provided');
    next(null, false);
});

// Strategy to check token
let checkStrategy = new JwtStrategy(jwtOptions, function (jwt_payload, next) {
    console.log('PAYLOAD RECIBIDO: ', jwt_payload);
    if (jwt_payload) {
        next(null, jwt_payload.user);
    } else {
        console.error('no token provided');
        next(null, false);
    }
});

//registra el servicio básico de autenticacion (usuario existe)
passport.use(passportConf.strategiesNames.userLevel, userLevelStrategy); // ( strategy name, strategy )
passport.use(passportConf.strategiesNames.check, checkStrategy); // ( strategy name, strategy )

let sign = (payload) => {
    return jwt.sign(payload, jwtOptions.secretOrKey, { expiresIn: passportConf.expireTime });
}

let hash = (content) => {
    return bcrypt.hashSync(content, bcryptConf.salt);
}

let compareHash = (content, hash) => {
    return bcrypt.compareSync(content, hash);
}
let randomTokenString = () => {
    return crypto.randomBytes(40).toString('hex');
}

let generateRefreshToken = (user, ipAddress) => {
    // create a refresh token that expires in 10 years
    // return new RefreshToken({
    //     user: user.id,
    //     token: randomTokenString(),
    //     expires: new Date(Date.now() + 10*365*24*60*60*1000),
    //     createdByIp: ipAddress
    // });
}

module.exports = {
    passport: passport,
    passportConfig: passportConf,
    sign: sign,
    hash: hash,
    compareHash: compareHash,
    generateRefreshToken: generateRefreshToken
};