const mongoose = require('mongoose');

const UserSchema = mongoose.Schema(
    {
      nombre: {
        type: String,
        required: true,
      },
      correo: {
        type: String,
        required: true,
      },
      grupo: {
        type: String,
        unique: true,
        required: true,
      },
      usuario: {
        type: String,
        unique: true,
        required: true,
      },
      
      password: {
        type: String,
        required: true,
      },
      
      id: {
        type: String,
        required: true,
      },
    }
  );
  


const RefreshTokenSchema = mongoose.Schema({
    user: UserSchema,
    token: String,
    expires: Date,
    created: { type: Date, default: Date.now },
    createdByIp: String,
    revoked: Date,
    revokedByIp: String,
    replacedByToken: String
});

RefreshTokenSchema.virtual('isExpired').get(function () {
    return Date.now() >= this.expires;
});

RefreshTokenSchema.virtual('isActive').get(function () {
    return !this.revoked && !this.isExpired;
});

RefreshTokenSchema.set('toJSON', {
    virtuals: true,
    versionKey: false,
    transform: function (doc, ret) {
        // remove these props when object is serialized
        delete ret._id;
        delete ret.id;
        delete ret.user;
    }
});
